/*+++ *******************************************************************\
*
*  Copyright and Disclaimer:
*
*     ---------------------------------------------------------------
*     This software is provided "AS IS" without warranty of any kind,
*     either expressed or implied, including but not limited to the
*     implied warranties of noninfringement, merchantability and/or
*     fitness for a particular purpose.
*     ---------------------------------------------------------------
*
*     Copyright (c) 2009 Conexant Systems, Inc.
*     All rights reserved.
*
\******************************************************************* ---*/

#ifndef _NXP18272_TABLES_H_
#define _NXP18272_TABLES_H_

#ifndef DRIVER_BUILD
#include "ksdef.h"
#include <winnls.h>
#endif

/*********************************************************************************/
// country code   --> Standard settings
/*********************************************************************************/
/*

    Standard                                Country

AnalogVideo_NTSC_M,       USA
                          Anguilla,Antigua,Bahamas,Barbados,Bermuda,British Virgin Islands,
                          Canada,Cayman Islands,Dominica,Dominican Republic,Grenada,
                          Jamaica,Montserrat,Nevis,St. Kitts,St. Vincent and the Grenadines,
                          Trinidad and Tobago,Turks and Caicos Islands,Barbuda,Puerto Rico,
                          Saint Lucia,United States Virgin Islands,Canada,Cape Verde Islands,
                          Guinea-Bissau,Diego Garcia,Ascension Island,Malawi,Comoros,
                          St. Helena,Eritrea,Aruba,Greenland,Andorra,Belize,Guatemala,
                          El Salvador,Honduras,Nicaragua,Costa Rica,Panama,Haiti,Peru,Mexico,
                          Cuba,Guantanamo Bay,Chile,Colombia,Bolivarian Republic of Venezuela,
                          French Antilles,Ecuador,Suriname,Netherlands Antilles,
                          Cocos-Keeling Islands,,Philippines,Saipan Island,Rota Island,
                          Tinian Island,Guam,Christmas Island,Australian Antarctic Territory,
                          Nauru,Tonga,Solomon Islands,Vanuatu,Fiji Islands,Palau,Niue,
                          Territory of American Samoa,Tuvalu,Tokelau,Micronesia,
                          Marshall Islands,Korea (South),Vietnam,INMARSAT (Atlantic-East),
                          INMARSAT (Pacific),INMARSAT (Indian),INMARSAT (Atlantic-West),Taiwan,
                          Myanmar,Bhutan


AnalogVideo_NTSC_M_J      Japan

AnalogVideo_PAL_B         Algeria,Liberia,Sierra Leone,Ghana,Nigeria,Chad,
                          Central African Republic,Cameroon,Sao Tome and Principe,
                          Seychelle Islands,Sudan,Rwanda,Ethiopia,Somalia,Kenya,Tanzania,
                          Uganda,Mozambique,Zambia,Zimbabwe,Swaziland,Lithuania,
                          Estonia,Spain,Gibraltar,Portugal,Luxembourg,Iceland,
                          Albania,Malta,Cyprus,Finland,Cambodia,Laos,Bangladesh,Turkey,
                          India,Pakistan,Afghanistan,Sri Lanka,Maldives,Jordan,
                          Kuwait,Yemen,Oman,United Arab Emirates,Israel,Bahrain,Qatar,Nepal,
                          Faroe Islands,Netherlands,Belgium,San Marino,Serbia and Montenegro,
                          Croatia,Slovenia,Bosnia and Herzegovina,
                          F.Y.R.O.M. (Former Yugoslav Republic of Macedonia),
                          Italy,Vatican City,Switzerland,Liechtenstein,Slovak Republic,
                          Austria,Denmark,Sweden,Norway,Poland,Germany,Malaysia,Australia,
                          Indonesia,New Zealand,Singapore,Thailand,Norfolk Island,Brunei,
                          Papua New Guinea,Cook Islands,Samoa,Kiribati Republic

AnalogVideo_PAL_I         Angola,Namibia,Lesotho,South Africa,Ireland,United Kingdom,
                          Falkland Islands (Islas Malvinas),Hong Kong SAR,Macao SAR

AnalogVideo_PAL_D         Romania,Czech Republic,China

AnalogVideo_PAL_N         Argentina,Bolivia,Paraguay,Uruguay

AnalogVideo_PAL_M         Brazil

AnalogVideo_SECAM_B       Lebanon,Syria,Iraq,Saudi Arabia,Iran,Egypt,Morocco,Tunisia,
                          Libya,Mauritania,Mauritius,Equatorial Guinea,Greece

AnalogVideo_SECAM_D       Ukraine,Azerbaijan,Georgia,Bulgaria,Hungary,Latvia,Moldova,
                          Armenia,Belarus,Congo,Russia,Kazakhstan,Kyrgyzstan,
                          Tajikistan,Turkmenistan,Uzbekistan,Mongolia,Korea (North)

AnalogVideo_SECAM_K       Djibouti,Burundi,Madagascar,Reunion Island,Gambia,Senegal Republic,
                          Mali,Guinea,Cote D'Ivoire,Burkina Faso,Niger,Togo,Benin,Gabon,
                          Congo(DRC),Botswana,Mayotte Island,St. Pierre and Miquelon,
                          Guadeloupe,Guyana,French Guiana,Martinique,Wallis and Futuna Islands,
                          New Caledonia,French Polynesia

AnalogVideo_SECAM_L       France

AnalogVideo_SECAM_G       Monaco

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


Video standards supported by Xceive      Video Standards defined by Microsoft :
-----------------------------------    ------------------------------------------

            Yes                         KS_AnalogVideo_NTSC_M   = 0x00000001,  //        75 IRE Setup
            Yes                         KS_AnalogVideo_NTSC_M_J = 0x00000002,  // Japan,  0 IRE Setup
            Yes                         KS_AnalogVideo_NTSC_433 = 0x00000004,

            Yes                         KS_AnalogVideo_PAL_B    = 0x00000010,
            Yes                         KS_AnalogVideo_PAL_D    = 0x00000020,
            Yes                         KS_AnalogVideo_PAL_G    = 0x00000040,
            No                          KS_AnalogVideo_PAL_H    = 0x00000080,
            Yes                         KS_AnalogVideo_PAL_I    = 0x00000100,
            Yes                         KS_AnalogVideo_PAL_M    = 0x00000200,
            Yes                         KS_AnalogVideo_PAL_N    = 0x00000400,

            No                          KS_AnalogVideo_PAL_60   = 0x00000800,

            No                          KS_AnalogVideo_SECAM_B  = 0x00001000,
            Yes                         KS_AnalogVideo_SECAM_D  = 0x00002000,
            No                          KS_AnalogVideo_SECAM_G  = 0x00004000,
            No                          KS_AnalogVideo_SECAM_H  = 0x00008000,
            Yes                         KS_AnalogVideo_SECAM_K  = 0x00010000,
            Yes                         KS_AnalogVideo_SECAM_K1 = 0x00020000,
            Yes                         KS_AnalogVideo_SECAM_L  = 0x00040000,
            Yes                         KS_AnalogVideo_SECAM_L1 = 0x00080000,

            Yes                         KS_AnalogVideo_PAL_N_COMBO  = 0x00100000


*/
/*********************************************************************************/
//Video standard

typedef struct _COUNTRY_VIDEO_TABLE_ENTRY{
    DWORD                   country_code;
    KS_AnalogVideoStandard  video_standard;
}COUNTRY_VIDEO_TABLE_ENTRY, *PCOUNTRY_VIDEO_TABLE_ENTRY;

static const COUNTRY_VIDEO_TABLE_ENTRY country_to_video_map_table[] =
{
//  Country Code                Video Standard
    {CTRY_UNITED_STATES,        KS_AnalogVideo_NTSC_M},
    {CTRY_UNITED_KINGDOM,       KS_AnalogVideo_PAL_I},
    {CTRY_GERMANY,              KS_AnalogVideo_PAL_B},
    {CTRY_JAPAN,                KS_AnalogVideo_NTSC_M_J},
    {CTRY_SPAIN,                KS_AnalogVideo_PAL_B},
    {CTRY_ALBANIA,              KS_AnalogVideo_PAL_B},
    {CTRY_ALGERIA,              KS_AnalogVideo_PAL_B},
    {CTRY_ARGENTINA,            KS_AnalogVideo_PAL_N},
    {CTRY_ARMENIA,              KS_AnalogVideo_SECAM_D},
    {CTRY_AUSTRALIA,            KS_AnalogVideo_PAL_B},
    {CTRY_AUSTRIA,              KS_AnalogVideo_PAL_B},
    {CTRY_AZERBAIJAN,           KS_AnalogVideo_SECAM_D},
    {CTRY_BAHRAIN,              KS_AnalogVideo_PAL_B},
    {CTRY_BELARUS,              KS_AnalogVideo_SECAM_D},
    {CTRY_BELGIUM,              KS_AnalogVideo_PAL_B},
    {CTRY_BELIZE,               KS_AnalogVideo_NTSC_M},
    {CTRY_BOLIVIA,              KS_AnalogVideo_NTSC_M},
    {CTRY_BRAZIL,               KS_AnalogVideo_PAL_M},
    {CTRY_BRUNEI_DARUSSALAM,    KS_AnalogVideo_PAL_B},
    {CTRY_BULGARIA,             KS_AnalogVideo_SECAM_D},
    {CTRY_CANADA,               KS_AnalogVideo_NTSC_M},
    {CTRY_CHILE,                KS_AnalogVideo_NTSC_M},
    {CTRY_COLOMBIA,             KS_AnalogVideo_NTSC_M},
    {CTRY_COSTA_RICA,           KS_AnalogVideo_NTSC_M},
    {CTRY_CROATIA,              KS_AnalogVideo_PAL_B},
    {CTRY_CZECH,                KS_AnalogVideo_PAL_D},
    {CTRY_DENMARK,              KS_AnalogVideo_PAL_B},
    {CTRY_ECUADOR,              KS_AnalogVideo_NTSC_M},
    {CTRY_EGYPT,                KS_AnalogVideo_SECAM_B},
    {CTRY_EL_SALVADOR,          KS_AnalogVideo_NTSC_M},
    {CTRY_ESTONIA,              KS_AnalogVideo_PAL_B},
    {CTRY_FAEROE_ISLANDS,       KS_AnalogVideo_PAL_B},
    {CTRY_FINLAND,              KS_AnalogVideo_PAL_B},
    {CTRY_FRANCE,               KS_AnalogVideo_SECAM_L},
    {CTRY_GEORGIA,              KS_AnalogVideo_SECAM_D},
    {CTRY_GREECE,               KS_AnalogVideo_PAL_B},
    {CTRY_GUATEMALA,            KS_AnalogVideo_NTSC_M},
    {CTRY_HONDURAS,             KS_AnalogVideo_NTSC_M},
    {CTRY_HONG_KONG,            KS_AnalogVideo_PAL_I},
    {CTRY_HUNGARY,              KS_AnalogVideo_PAL_B},
    {CTRY_ICELAND,              KS_AnalogVideo_PAL_B},
    {CTRY_INDIA,                KS_AnalogVideo_PAL_B},
    {CTRY_INDONESIA,            KS_AnalogVideo_PAL_B},
    {CTRY_IRAN,                 KS_AnalogVideo_SECAM_B},
    {CTRY_IRAQ,                 KS_AnalogVideo_SECAM_B},
    {CTRY_IRELAND,              KS_AnalogVideo_PAL_I},
    {CTRY_ISRAEL,               KS_AnalogVideo_PAL_B},
    {CTRY_ITALY,                KS_AnalogVideo_PAL_B},
    {CTRY_JORDAN,               KS_AnalogVideo_PAL_B},
    {CTRY_KAZAKSTAN,            KS_AnalogVideo_SECAM_D},
    {CTRY_KENYA,                KS_AnalogVideo_PAL_B},
    {CTRY_KUWAIT,               KS_AnalogVideo_PAL_B},
    {CTRY_LATVIA,               KS_AnalogVideo_PAL_B},
    {CTRY_LEBANON,              KS_AnalogVideo_PAL_B},
    {CTRY_LIBYA,                KS_AnalogVideo_PAL_B},
    {CTRY_LIECHTENSTEIN,        KS_AnalogVideo_PAL_B},
    {CTRY_LITHUANIA,            KS_AnalogVideo_PAL_B},
    {CTRY_LUXEMBOURG,           KS_AnalogVideo_PAL_B},
    {CTRY_MACAU,                KS_AnalogVideo_PAL_I},
    {CTRY_MACEDONIA,            KS_AnalogVideo_PAL_B},
    {CTRY_MALAYSIA,             KS_AnalogVideo_PAL_B},
    {CTRY_MEXICO,               KS_AnalogVideo_NTSC_M},
    {CTRY_MONACO,               KS_AnalogVideo_SECAM_L},
    {CTRY_MOROCCO,              KS_AnalogVideo_SECAM_B},
    {CTRY_NETHERLANDS,          KS_AnalogVideo_PAL_B},
    {CTRY_NEW_ZEALAND,          KS_AnalogVideo_PAL_B},
    {CTRY_NICARAGUA,            KS_AnalogVideo_NTSC_M},
    {CTRY_NORWAY,               KS_AnalogVideo_PAL_B},
    {CTRY_OMAN,                 KS_AnalogVideo_PAL_B},
    {CTRY_PAKISTAN,             KS_AnalogVideo_PAL_B},
    {CTRY_PANAMA,               KS_AnalogVideo_NTSC_M},
    {CTRY_PARAGUAY,             KS_AnalogVideo_PAL_N},
    {CTRY_PERU,                 KS_AnalogVideo_NTSC_M},
    {CTRY_PHILIPPINES,          KS_AnalogVideo_NTSC_M},
    {CTRY_POLAND,               KS_AnalogVideo_PAL_D},
    {CTRY_PORTUGAL,             KS_AnalogVideo_PAL_B},
    {CTRY_PRCHINA,              KS_AnalogVideo_PAL_D},
    {CTRY_QATAR,                KS_AnalogVideo_PAL_B},
    {CTRY_ROMANIA,              KS_AnalogVideo_PAL_D},
    {CTRY_RUSSIA,               KS_AnalogVideo_SECAM_D},
    {CTRY_SAUDI_ARABIA,         KS_AnalogVideo_PAL_B},
    {CTRY_SERBIA,               KS_AnalogVideo_PAL_B},
    {CTRY_SINGAPORE,            KS_AnalogVideo_PAL_B},
    {CTRY_SLOVAK,               KS_AnalogVideo_PAL_B},
    {CTRY_SLOVENIA,             KS_AnalogVideo_PAL_B},
    {CTRY_SOUTH_AFRICA,         KS_AnalogVideo_PAL_I},
    {CTRY_SOUTH_KOREA,          KS_AnalogVideo_NTSC_M},
    {CTRY_SWEDEN,               KS_AnalogVideo_PAL_B},
    {CTRY_SWITZERLAND,          KS_AnalogVideo_PAL_B},
    {CTRY_SYRIA,                KS_AnalogVideo_SECAM_B},
    {CTRY_TAIWAN,               KS_AnalogVideo_NTSC_M},
    {CTRY_TATARSTAN,            KS_AnalogVideo_SECAM_D},
    {CTRY_THAILAND,             KS_AnalogVideo_PAL_B},
    {CTRY_TUNISIA,              KS_AnalogVideo_SECAM_B},
    {CTRY_TURKEY,               KS_AnalogVideo_PAL_B},
    {CTRY_UAE,                  KS_AnalogVideo_PAL_B},
    {CTRY_UKRAINE,              KS_AnalogVideo_SECAM_D},
    {CTRY_URUGUAY,              KS_AnalogVideo_PAL_N},
    {CTRY_UZBEKISTAN,           KS_AnalogVideo_SECAM_D},
    {CTRY_VENEZUELA,            KS_AnalogVideo_NTSC_M},
    {CTRY_VIET_NAM,             KS_AnalogVideo_SECAM_D},
    {CTRY_YEMEN,                KS_AnalogVideo_PAL_B},
    {CTRY_ZIMBABWE,             KS_AnalogVideo_PAL_B},
};


#endif // _NXP18272_TABLES_H_